//
// ROOM ACCESS CONTROL
//   Counts people with previous temperature measure
//---------------------******--------------------------//
//
// Include:
//    - MLX90614 contactless temperature sensor.
//    - HC-SR04 sonar module to read person pass.
//    - Average estimation to smooth measures.
//    - Interface via LCD display with I2C
//
// Based on:
//    - Arduino UNO
//    - https://www.prometec.net/midiendo-temperatura-sin-contacto/
//    - https://www.electroallweb.com/index.php/2020/07/13/contador-de-aforo-automatico-proyecto-prevencion-covid-19/
//    - Arduino online open community. Thank you all!
//
// Licensed under Creative Commons (SH-BY-NC).
//.
// Félix Vidarte Vidarte (mipinilla@alumnos.unex.es)
// Miguel Ángel Pinilla Charro (fevidarte@alumnos.unex.es)
//
// Smart Open Lab. Escuela Politécnica de Cáceres. Universidad de Extremadura.
// @SolEpcc
//
//--------------------******---------------------------//

#include "SR04.h"
#include <Wire.h>                 
#include <LiquidCrystal_I2C.h> 
#include <Adafruit_MLX90614.h>
#define TRIG_PIN1 12
#define ECHO_PIN1 11
#define TRIG_PIN2 8
#define ECHO_PIN2 9
SR04 sr1 = SR04(ECHO_PIN1,TRIG_PIN1);
SR04 sr2 = SR04(ECHO_PIN2,TRIG_PIN2);

Adafruit_MLX90614 termometroIR = Adafruit_MLX90614();

LiquidCrystal_I2C lcd(0x27,16,2);

int periodo = 5000;  
int buzzPin = 7;
int valorPulsador = 0;

long flag1; long flag3;     //Banderas que controlan el sensor 1
long flag2; long flag4;     //Banderas que controlan el sensor 2

unsigned long ta1 = 0;      //Tiempo sensor 1
unsigned long ta2 = 0;      //Tiempo sensor 2

long i=0;
long a;                     //Distancia sensor 1
long b;                     //Distancia sensor 2
long aca;
long acb;

long proma;
long promb;

int maximo = 5;             //Capacidad máxima de la sala
long contador=0;            //Contador de porsonas en la sala

const int pulsadorPin = 2;

void setup() {
  Serial.begin(9600);
  delay(1000);
  lcd.init();                     
  lcd.backlight();     
  termometroIR.begin();    
  pinMode(buzzPin, OUTPUT);  
  pinMode(pulsadorPin, INPUT);     
}

void loop() {
  
  float temperaturaObjeto = termometroIR.readObjectTempC();
  valorPulsador = digitalRead(pulsadorPin);

   a=sr1.Distance();
   b=sr2.Distance();
   
   i=i+1;                                                             //
  aca=(aca+a);                                                        //
  acb=(acb+b);                                                        // Sistema para controlar el promedio de los valores de ambos sensores
  proma=aca/i;                                                        //
  promb=acb/i;                                                        //
  
 
  if (proma <=15){                                                    //                                               
        flag1=1;                                                      //
        ta1=millis();                                                 //
  }                                                                   //Controla el movimiento por el sensor 1
  if ((flag1==1 && ta1+periodo<millis()) || flag3==1){                //
      flag1=0;                                                        //
      flag3=0;                                                        //
  }
  
  if (promb <=15){                                                    //
        flag2=1;                                                      //
        ta2=millis();                                                 //
  }                                                                   //Controla el movimiento por el sensor 2
  if ((flag2==1 && ta2+periodo<millis()) || flag4==1){                //
      flag2=0;                                                        //
      flag4=0;                                                        //
  }
  
  if(flag1==1 && flag2==1){                                           //Comprueba si ambos sensores se han activado
    flag3=1;
    flag4=1;
    
    if(ta1<ta2 && contador < maximo){                                 //Comprueba si el sensor 1 se ha activado antes que el 2
        lcd.setCursor(0,0);                                           // Controla la entrada
        lcd.print("Entering...  ");
        delay(1500);
        contador=contador+1;
        lcd.setCursor(0,0);  
        lcd.print("Capacity: ");          
        if(contador<10){
            lcd.print("0");
            lcd.print(contador);
        }
        else{
            lcd.print(contador);
         }
          
    }
    
    else{
        lcd.setCursor(0,0);                                           //Controla la salida
        lcd.print("Coming out...");
        delay(1500);
        contador=contador-1;
        if (contador<0){
            contador=0;
        }
        lcd.setCursor(0,0);  
        lcd.print("Capacity: ");   
        if(contador<10){
            lcd.print("0");
            lcd.print(contador);
        }
        else{
            lcd.print(contador);     
        }
   } 
 }
 
   
if (contador>=maximo){                                    //Controla el aforo máximo y saca un mensaje por pantalla
    lcd.setCursor(0,0);
    lcd.print("!  FULL  !");
    lcd.setCursor(0,1);
    lcd.print("               ");
  }
 /* Serial.print(proma);            
   Serial.println("cm");                 //Saca valores en el monitor serie de los sensores 
   Serial.print(promb);                   
   Serial.println("cm");                           
*/

if (i==15){                                 //
  aca=0;                                    //Cada 1.5 segundos vuelve a poner los acumuladores a 0 para el control del promedio
  acb=0;                                    //
  i=0;                                      //
 }
 
if (valorPulsador == HIGH) {                             // Controla el pulsador
   lcd.setCursor(0,0);  
   lcd.print("T:    ");
   lcd.print(temperaturaObjeto);
   delay(500);
   if(temperaturaObjeto>=38){                            // Controla el valor de temperatura y saca un mensaje por por pantalla
      tone(buzzPin,220);
      delay(200);
      noTone(buzzPin);
      delay(200);
      lcd.setCursor(0,1);  
      lcd.print("Acess denied");
      delay(2000);
      lcd.setCursor(0,1);  
      lcd.print("            ");
      
   }
   else{
      lcd.setCursor(0,1);  
      lcd.print("You can enter");
      delay(2000);
      lcd.setCursor(0,1);  
      lcd.print("             ");
   }
   }
   delay(100);
 }
   
   
  
  
