#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
#include <OneWire.h>
#include <DallasTemperature.h>

int TRIGGER = 13; //D7
int ECHO   = 12; //D6
const int oneWireBus = 5;  //D1   
const int profundidad = 15; //profundidad de la piscina en cm

const char* ssid = "nombre_wifi"; //nombre wifi
const char* password = "contraseña"; //contraseña wifi
ESP8266WebServer server(80);   //inicia el servidor en el puerto 80 (http port)

OneWire oneWire(oneWireBus);
DallasTemperature sensors(&oneWire);

String page = "";
int data; 
float data2;
void setup(void){

  
 pinMode(TRIGGER, OUTPUT); 
 pinMode(ECHO, INPUT); 
  delay(1000);
  Serial.begin(115200);
  sensors.begin(); //Inicio sensor temperatura
  WiFi.begin(ssid, password); //Inicio conexion wifi
  Serial.println("");
  // Wait for connection
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  server.on("/", [](){
    page = "<head><meta http-equiv=\"refresh\" content=\"3\"></head><center><h1>Controlador piscina</h1><h3>El nivel actual de agua es :-</h3> <h4>"+String(data)+"%";
    if (data <= 70){
      page = page + "</h4><h3>ATENCION! El nivel de agua es demasiado bajo, deberia llenar la piscina</h3> <h4>";
    }
    page = page + "</h4><h3>La temperatura del agua en grados Celsius es :-</h3> <h4>"+String(data2)+"</h4></center></center>";
    server.send(200, "text/html", page);
  });
  server.begin();
  Serial.println("Web server started!");
}
 void loop(void){
  sensors.requestTemperatures(); 
  float temperatura = sensors.getTempCByIndex(0);
  data2 = temperatura;
  delay(5000);
  
  digitalWrite(TRIGGER, LOW);  
  delayMicroseconds(2); 
  digitalWrite(TRIGGER, HIGH);
  delayMicroseconds(10); 
  digitalWrite(TRIGGER, LOW);
  long duration= pulseIn(ECHO, HIGH);
  float distance = (duration/2)/29.09;
  float agua = ((profundidad-distance)/profundidad)*100; //calcula el porcentaje de agua en función de la profundidad de la piscina
  if (agua<0) {
    agua = 0;
    }
  data = agua;
  server.handleClient();
}
