#include <LiquidCrystal_I2C.h>

#include <Wire.h>

#include <DHT.h>

//Configuramos pines y variables
int SENSOR = 8;//Pin 8 para el valor del sensor DHT11
int temp, humedad;//Configuramos las variables de temperatura y humedad del DHT11
const int bomba = 13; //Pin 13 para la bomba
const int sensoragua = A1; //A1 para el sensor nivel de agua
const int humedadsuelo = A0; //A0 para la humedad del suelo

DHT dht (SENSOR, DHT11);//Configuramos el modelo de DHT. Es el DHT11
LiquidCrystal_I2C lcd(0x27,16,2); 

void setup()
{
  Serial.begin(9600);//Arrancamos el puerto serie a 9600
  //Configuramos entradas y salidas
  pinMode(humedadsuelo, INPUT);//Configuramos humedadsuelo como entrada
  pinMode(bomba, OUTPUT);//Configuramos bomba como salida
  pinMode(sensoragua, INPUT);//Configuramos el nivel de agua como entrada
  // Inicializar el LCD
  lcd.init();
 //Encender la luz de fondo.
  lcd.backlight();
  
  dht.begin();//Arrancamos el sensor DHT11
 }

void loop()
{
  lcd.setCursor(0,0);
  lcd.print("   SISTEMA EN ");
  lcd.setCursor(0,1);
  lcd.print(" FUNCIONAMIENTO");
  int SensorTierra = analogRead(humedadsuelo);//Leemos el valor de la humedad y lo metemos en SensorTierra
  int SensorAgua = analogRead(sensoragua);//Leemos el valor del nivel de agua y lo metemos en SensorAgua
  //Leemos y metemos los valores de temperatura y humedad en las variables temp y humedad
  humedad = dht.readHumidity();
  temp = dht.readTemperature();
  
  //Imprimimos por el puerto serie los valores de temperatura y humedad del DHT11
  Serial.print("Temperatura: "); Serial.print(temp);
  Serial.print("ºC Humedad: "); Serial.print(humedad); Serial.println("%");
  
  //Imprimimimos por el puerto serie el valor de la humedad del suelo
  Serial.print("Nivel de agua de la bomba: ");Serial.println(SensorAgua);
  Serial.print("Humedad del suelo: ");Serial.print(SensorTierra); Serial.println("%");
  delay(3000);

//Comprobamos si hay o no agua en el bidon
if (SensorAgua>=300) // si hay agua comprobamos si cumple las condiciones dadas de temperatura y humedad en el suelo
  {
   Serial.println("Nivel de agua correcto, se puede regar");
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("      AGUA");
  lcd.setCursor(0,1);
  lcd.print("    CORRECTA");
  delay(2500);
   if(SensorTierra >= 200) // el valor que consideramos seco y hay que regar es de 500
  {
   Serial.println("La tierra está seca");
   lcd.clear();
   lcd.setCursor(0,0);
   lcd.print("     TIERRA");
   lcd.setCursor(0,1);
   lcd.print("      SECA");
   delay(2500);
      if(temp<=15)
      {
      // Si cumple que hay agua, la tierra está seca y la temperatura es menor que cierto umbral, el sistema regará
        lcd.clear();
        lcd.setCursor(0,0);
        lcd.print("  TEMPERATURA");
        lcd.setCursor(0,1);
        lcd.print("    IDONEA");
        delay(2500);
        Serial.println("Temperatura idonea");
        lcd.clear();
        lcd.setCursor(0,0);
        lcd.print("   CUMPLE LAS");
        lcd.setCursor(0,1);
        lcd.print("  CONDICIONES");
        delay(2500);
        digitalWrite(bomba, HIGH);
        lcd.clear();
        lcd.setCursor(0,0);
        lcd.print("    SISTEMA  ");
        lcd.setCursor(0,1);
        lcd.print("    REGANDO  ");
        delay(5000);
        digitalWrite(bomba, LOW);
        lcd.clear();
        delay(500);
  }
      else{ // si no cumple que la temp esté por debajo del umbral
          Serial.println("La temperatura no es optima, no regar");
          lcd.clear();
          lcd.setCursor(0,0);
          lcd.print(" TEMP NO OPTIMA");
          lcd.setCursor(0,1);
          lcd.print("    NO REGAR");
          delay(2500); 
      }
 }  
   else{ // si no cumple que la tierra esté seca
      Serial.println("La tierra está húmeda, no regar");
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print(" TIERRA HUMEDA");
      lcd.setCursor(0,1);
      lcd.print("    NO REGAR");
      delay(2500);
   }
}  
else{   // si no hay agua, mostraremos en el display el valor de la temperatura, la humedad en el aire y en el suelo.
lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("  NO HAY AGUA");
  lcd.setCursor(0,1);
  lcd.print("RELLENA EL BIDON");
  delay(2500);
  Serial.println("Nivel bajo de Agua. Rellenar el tanque"); 
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("DHT:");
  lcd.print(temp);
  lcd.print("C/");
  lcd.print(humedad);
  lcd.print("%");
  lcd.setCursor(0,1);
  lcd.print("HumSuelo:");
  lcd.print(SensorTierra);
  lcd.print("%");
  delay(2000); 
}

  lcd.clear();
  delay(1000);
}
