/* Sistema de riego automático controlado por dos sensores (Temperatura, humedad)
 *  Cuando ambos sensores reciben los parámetros establecidos, se activa el sistema de riego,
 *  cuando esto no se cuemple:
 *  los parámetros no se activan
 *  
 *  
 *  Autor: Antonio González Fuentes, Ingeniería en Telecomunicaciones (Escuela Politécnica de Cáceres)
 *  
 */

//incluimos las librerías que vamos a usar
#include "DHT.h"
//#include "DHT.H"
//#define DHT11_pin;  //aquí ponemos el nombre y el lugar del sensor de temperatura y humedad

//Pantalla LCD
#include <Wire.h>
#include <LiquidCrystal_I2C.h>

//Declaramos las variables y las inicializamos a cero
float valorTemperatura=0;
float valorHumedad_Aire=0;
float valorHumedad_suelo=0;
float HumedadSuelo=0;
bool RIEGO= LOW;
bool RiegoE= HIGH;



//Asignamos las entradas y salidas de la placa
int LEDencendido=13 ;

int LEDriego =12 ;
int PinRiego = 3 ;
//LiquidCrystal lcd();
LiquidCrystal_I2C lcd(0x27,16,4);

//Declaraciones para el uso de pantalla LCD
//#define COLS 16 //Columnas del LCD
//#define ROWS 2 //Filas del LCD

//Definimos el sensor DHT11
#define DHTPIN 4
#define DHTTYPE DHT11 //Declaramos que usaremos el DHT11
DHT dht(DHTPIN, DHTTYPE); //Inicializamos el sensor DHT11

//Definimos el sensor YL-69
int sensorSuelo = A0; //asignamos el sensor al pin de la placa

//definimos un rele para activar el sistema de riego
#define LED_BUILTIN 7;
//LED_BUILTIN 7;

void setup() {
  // put your setup code here, to run once:
  pinMode (LEDriego, OUTPUT); //Asignamos pinRiego como salida a la placa
  pinMode (LEDencendido, OUTPUT); //Asignamos LEDencendido como la salida en la placa
  pinMode (DHTPIN, INPUT); //Asignamos DHTpin como entrada en la placa
  pinMode(sensorSuelo, INPUT); //Asignamos YL-69 como entrada en la placa
  pinMode (PinRiego, OUTPUT); //Asignamos el motor de riego como salida en la placa
  pinMode (7, OUTPUT); //Asignamos el modulo-rele a nuestro pin digital como salida en la placa
  Serial.begin(9600); //Inicializamos el puerto serie
  //lcd.begin(COLS, ROWS); //Configuramos las filas y las columnas del LCD

  //Configuramos pantalla LCDI2C
  //lcd.clear();
  lcd.init();
  lcd.backlight();
  lcd.setCursor(1,0);
  lcd.print("el programa se");
  lcd.setCursor(1,0);
  lcd.print("está iniciando");
  
  lcd.clear();
  

  dht.begin (); //Iniciamos el sensor DHT11

  digitalWrite(LEDencendido, HIGH); //Mostramos led encendidio al iniciar el programa

}

void loop() {
  // put your main code here, to run repeatedly:
  //Iniciamos el sistema
  lcd.clear();
  lcd.setCursor(1,0);
  lcd.print("SISTEMA EN ");
  lcd.setCursor(1,1);
  lcd.print("FUNCIONAMIENTO ");
  delay(1000); //Esperamos un segundo entre mediciones
  
  //DHT.read11(DHT11_pin);

  //Valores de temperatura y humedad
  valorTemperatura= dht.readTemperature(); //Leemos la temperatura en grados Centigrados
  valorHumedad_Aire=dht.readHumidity(); //Leemos la humedad

  float TF= dht.readTemperature(true); //Leemos la temperatura en grados Fahrenheit, solo lo usaré 
  //para asegurarme de que el sensor funciona

  //comprobamos existentes errores en el sensor
  if (isnan(valorHumedad_Aire) || isnan (valorTemperatura) || isnan (TF)){
    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("Error en sensor DHT11");
    delay (5000);
  }
  //utilizaremos la función isnan (), que nos devolverá un “1” en el caso de 
  //que el valor no sea numérico, síntoma de que habrá un error en la lectura.

  //Tomamos las mediciones del sensor de suelo YL-69 (Humedad en tierra)
  //Valores de Humedad
  valorHumedad_suelo=analogRead(sensorSuelo);
  //HumedadSuelo= map(valorHumedad_suelo);  //Escala la lectura analógica

  //Una vez obtenidos los valores iniciales y mostrados al usuario, procedemos a verificar si es
  //necesario el riego o no

  //si tenemos activado el riego automático
  //if ( (valorHumedad_suelo < 50) && (valorTemperatura < 30) && (RiegoE == HIGH)) {
  if ( (HumedadSuelo < 50) && (valorTemperatura < 30) && (RiegoE == HIGH)) {
    digitalWrite (7, HIGH);
    digitalWrite(PinRiego, HIGH);
    lcd.clear ();
    //lcd.setCursor(1,0);
    lcd.print ("Riego Activado");
    lcd.setCursor(0,1);
    lcd.print ("Automaticamente");
    digitalWrite(LEDriego, HIGH);
    delay(5000); //el tiempo se puede cambiar el tiempo para hora real o utilizar milisegundos

    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("inicializando");
    lcd.setCursor(1,1);
    lcd.print("lectura");
    delay(2000);
    
    lcd.clear();
    lcd.print("temperatura:");
    lcd.setCursor (0,1);
    lcd.print(String (valorTemperatura)+ "C");
    delay (1500);

    lcd.clear();
    lcd.print("Humedad en Aire:");
    lcd.setCursor (0,1);
    lcd.print(String (valorHumedad_Aire) + "%");
    delay(1500);

    lcd.clear();
    lcd.print("Humedad suelo:");
    lcd.setCursor (0,1);
    lcd.print(String(HumedadSuelo)+ "%");
    delay(1500);

    digitalWrite(7,LOW);
    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("Riego Apagado");
    lcd.setCursor(0,1);

    lcd.print("Automaticamente");
    digitalWrite(PinRiego, LOW);
    digitalWrite(LEDriego, LOW);
    delay(2000);
    lcd.clear();
    
  }
  else{
    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("inicializando");
    lcd.setCursor(1,1);
    lcd.print("lectura");
    delay(2000);
    
    lcd.clear();
    lcd.print("temperatura:");
    lcd.setCursor (0,1);
    lcd.print(String (valorTemperatura)+ "C");
    delay (1500);

    lcd.clear();
    lcd.print("Humedad en Aire:");
    lcd.setCursor (0,1);
    lcd.print(String (valorHumedad_Aire) + "%");
    delay(1500);

    lcd.clear();
    lcd.print("Humedad suelo:");
    lcd.setCursor (0,1);
    lcd.print(String(HumedadSuelo)+ "%");
    delay(1500);

    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("No se cumplen");
    lcd.setCursor(1,1);
    lcd.print("los valores");
    delay(1500);

    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("El riego se");
    lcd.setCursor(1,1);
    lcd.print("quedará cerrado");
    delay(1500);
  }

  if ( (valorHumedad_Aire < 20) && (valorTemperatura > 20) && (RiegoE == HIGH)){
    digitalWrite (7, HIGH);
    digitalWrite(PinRiego, HIGH);
    lcd.clear ();
    lcd.setCursor(1,0);
    lcd.print ("Riego Activado");
    lcd.setCursor(1,1);
    lcd.print ("Automaticamente");
    digitalWrite(LEDriego, HIGH);
    delay(7000); //el tiempo se puede cambiar el tiempo para hora real o utilizar milisegundos

    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("inicializando");
    lcd.setCursor(1,1);
    lcd.print("lectura");
    delay(2000);
    
    lcd.clear();
    lcd.print("temperatura:");
    lcd.setCursor (0,1);
    lcd.print(String (valorTemperatura)+ "C");
    delay (1500);

    lcd.clear();
    lcd.print("Humedad en Aire:");
    lcd.setCursor (0,1);
    lcd.print(String (valorHumedad_Aire) + "%");
    delay(1500);

    lcd.clear();
    lcd.print("Humedad suelo:");
    lcd.setCursor (0,1);
    lcd.print(String(HumedadSuelo)+ "%");
    delay(1500);

    digitalWrite(7,LOW);
    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("Riego Apagado");
    lcd.setCursor(0,1);

    lcd.print("Automaticamente");
    digitalWrite(PinRiego, LOW);
    digitalWrite(LEDriego, LOW);
    delay(2000);
    lcd.clear();
    
  }
  else{
    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("inicializando");
    lcd.setCursor(1,1);
    lcd.print("lectura");
    delay(2000);
    
    lcd.clear();
    lcd.print("temperatura:");
    lcd.setCursor (0,1);
    lcd.print(String (valorTemperatura)+ "C");
    delay (1500);

    lcd.clear();
    lcd.print("Humedad en Aire:");
    lcd.setCursor (0,1);
    lcd.print(String (valorHumedad_Aire) + "%");
    delay(1500);

    lcd.clear();
    lcd.print("Humedad suelo:");
    lcd.setCursor (0,1);
    lcd.print(String(HumedadSuelo)+ "%");
    delay(1500);

    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("No se cumplen");
    lcd.setCursor(1,1);
    lcd.print("los valores");
    delay(1500);

    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("El riego se");
    lcd.setCursor(1,1);
    lcd.print("quedará cerrado");
    delay(1500);
  }

}
