// Arduino Car Parking System Definitivo
/*Sistema de aparcamiento para coches basado en la utilización de sensores de proximidad infrarrojos para la detección de los vehículos y la utilización
 * de un servomotor que levante la valla cuando el vehículos vaya a entrar al parking y la cierre tras él cuando este haya entrado.
 *
 *Autora: Laura Rosa Gil
 *Grado en Ingeniería de Sonido e Imagen en Telecomunicaciones (Escuela Politécnica de Cáceres)
 */

//Incluímos las librerías que vamos a usar
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2);  

#include <Servo.h> 
Servo myservo1;

//Asignamos las entradas y salidas de la placa
int IR1 = 2;
int IR2 = 4;

int Slot = 5;           //Número total de aparcamientos

//Banderas que controlan los sensores
int flag1 = 0;
int flag2 = 0;

void setup() {
  lcd.init();
  lcd.backlight();
  pinMode(IR1, INPUT);
  pinMode(IR2, INPUT);            //Asignamos IR1 e IR2 como entrada en la placa
  
  myservo1.attach(9);
  myservo1.write(90);             //Primera posición (ángulo) que toma el servomotor

  //Inicialización de la pantalla LCD
  lcd.setCursor (0,0);
  lcd.print("     ARDUINO    ");
  lcd.setCursor (0,1);
  lcd.print(" PARKING SYSTEM ");
  delay (2000);
  lcd.clear();  
}

void loop(){ 

if(digitalRead (IR1) == LOW && flag1==0){                     //
  if(Slot>0){flag1=1;                                         //Controla el movimiento por el sensor 1
    if(flag2==0){myservo1.write(180); Slot = Slot-1;}         //Levanta la valla para dejar pasar al vehículo y avisa que hay un aparcamiento menos disponible
  }
  else{
    lcd.setCursor (0,0);                                      //      
    lcd.print("    SORRY :(    ");                            //
    lcd.setCursor (0,1);                                      //Cuando el parking está completo, avisa en la pantalla LCD
    lcd.print("  Parking Full  ");                            //
    delay (3000);                                             //
    lcd.clear();                                              //
  }
}

if(digitalRead (IR2) == LOW && flag2==0){flag2=1;             //Controla el movimiento por el sensor 2
  if(flag1==0){myservo1.write(180); Slot = Slot+1;}           //Levanta la valla para dejar pasar al vehículo y avisa que hay un aparcamiento más disponible
}

if(flag1==1 && flag2==1){                                     //
  delay (1000);                                               //Comprueba si ambos sensores se han activado
  myservo1.write(100);                                        //Baja la valla porque el vehículo ya habrá entrado o salido
  flag1=0, flag2=0;                                           //
}

lcd.setCursor (0,0);                                          
lcd.print("    WELCOME!    ");                                
lcd.setCursor (0,1);                                          
lcd.print("Slot Left: ");                                     
lcd.print(Slot);                                              
}
