/*
 * 
 */ 

#include "MedianFilterLib.h"
#include "MIDIUSB.h"

const int numBotones=12;
const int numPotes=2;

int nota[]={48,49,50,51,52,53,54,55,56,57,58,59}; // Array con las 12 notas
int pines_botones[]={0,2,3,4,5,6,7,8,9,10,1,15};
int valorLeido[numBotones];    // Array con los valores leidos de cada botón
int valorAnterior[numBotones]; // Array con el valor anterior leido

int analogLeido[numPotes];     // Array con los valores leidos de cada Potenciómetro
int analogAnterior[numPotes];  // Array con el valor anterior leido Potenciómetros
MedianFilter<int> medianFilter(20); // Inicia el filtro de mediana con una ventana de 20

int echo = 20;    // Pin para echo                          
int trigger = 21; // Pin para trigger   

int control = 0;
int tiempoRespuesta;
int distancia=0;
int distanciaAnterior=0;




void setup() {
  Serial.begin(9600);
  for(int i=0; i<numBotones; i++){
     pinMode(pines_botones[i], INPUT_PULLUP);// Recorremos cada pin y lo ponemos como entrada
     valorAnterior[i]=1;        // Inicializamos el valor anterior a 1 (no pulsado)
  }
   pinMode(echo, INPUT_PULLUP);
   pinMode(trigger, OUTPUT);
 
  for(int i=0; i<=numBotones-1; i++){ 
     midiEventPacket_t noteOff = {0x08, 0x80 | 1, nota[i], 64};
     MidiUSB.sendMIDI(noteOff);
     MidiUSB.flush();
  }
}


void loop() {
  // Escaneo de PULSADORES
  for(int i=0; i<numBotones; i++){ 
    int pin = pines_botones[i];
    valorLeido[i] = digitalRead(pin);  // Leer pulsador
    if((valorLeido[i]==0) && (valorLeido[i]!=valorAnterior[i])){ // Solo enviamos cuando ha existido un cambio
      noteOn(1, nota[i], 64); // Activa nota correspondiente a cada pin 
      MidiUSB.flush();
      //Serial.println("Se ha activado el pin");
      //Serial.println(pin);
    }
    else if ((valorLeido[i]==1) && (valorLeido[i]!=valorAnterior[i])){
      noteOff(1, nota[i], 64); // Desactiva nota correspondiente a cada pin 
      MidiUSB.flush();
    }
    valorAnterior[i]=valorLeido[i]; // El valor leido pasa a ser valorAnterior para el proximo ciclo
  }


  // SENSOR DISTANCIA
  // Se toman 20 muestras de la lectura de la distancia
  for(int i=0; i<20; i++){
    medianFilter.AddValue(medir()); // Se agregan los valores analogicos al filtro de mediana móvil
    //delayMicroseconds(10);  
  }
  distancia = medianFilter.GetFiltered(); //se filtra con la mediana
  //discrimina para evitar errores
  if(distancia>=10 && distancia<=40 && distancia != distanciaAnterior){ 
    int control = map(distancia,10,40,0,127);  //escala el valor a un entero entre 0 y 127
    //Serial.println("Distancia:");
    //Serial.println(control);
    controlChange(0, 1, control); //usa la función de enviar cambios de control
    //delay(2); //espera 10 ms
    }
  MidiUSB.flush(); //Refresca comunicacion USB HID MIDI
  distanciaAnterior=distancia; 


  // POTENCIÓMETROS
  // Potenciómetros conectados a partir del pin 18
  for(int i=0; i<numPotes; i++){
    // Se toman 20 muestras consecutivas de cada puerto analogico 
    for(int j=0;j<20;j++){
      
      medianFilter.AddValue(analogRead(18+i)); // Se agregan los valores analogicos al filtro de mediana movil
    }
    analogLeido[i]= map(medianFilter.GetFiltered(), 0, 1023, 127,0); // El valor filtrado se acondiciona 
    // Verificamos si hay cambio en el potenciometro
    if(analogLeido[i]!=analogAnterior[i]){
      controlChange(0, i+2, analogLeido[i]); // Envia el valor del potenciometro que ha cambiado de estado
      //Serial.println(analogLeido[i]);
      MidiUSB.flush();
    }
    analogAnterior[i]=analogLeido[i]; // El valor analogLeido pasa a ser el analogAnterior para el proximo ciclo
  } 
}


// ENCENDER NOTA MIDI
void noteOn(byte channel, byte pitch, byte velocity) {
  midiEventPacket_t noteOn = {0x09, 0x90 | channel, pitch, velocity};
  MidiUSB.sendMIDI(noteOn);
}

// APAGAR NOTA MIDI
void noteOff(byte channel, byte pitch, byte velocity) {
  midiEventPacket_t noteOff = {0x08, 0x80 | channel, pitch, velocity};
  MidiUSB.sendMIDI(noteOff);
}

// ENVIAR CAMBIO DE CONTROL
void controlChange(byte channel, byte control, byte value) {
  midiEventPacket_t event = {0x0B, 0xB0 | channel, control, value};
  MidiUSB.sendMIDI(event);
}

// MEDIR DISTANCIA AL SENSOR (cm)
int medir(){
  int dist;
  //digitalWrite(trigger, LOW);  //para generar un pulso limpio ponemos a LOW 4us
  //delayMicroseconds(2);
  digitalWrite(trigger, HIGH);            // Enviamos pulso de 10 microsegundos
  delayMicroseconds(10);                        
  digitalWrite(trigger, LOW);                   
  tiempoRespuesta = pulseIn(echo, HIGH);  // Y esperamos pulso de vuelta
  dist = tiempoRespuesta/58;                 // Calculo de distancia en cm
  return dist;
}
